/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLine.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "Cline.h"
#include "CApplication.h"

//	Creates a line using the two given points
//	and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLine(double startX, double startY, double endX, double endY, ILine **dLine1)
{

	START_METHOD("CreateLine")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create the startVector
	IVector *startVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(startX, startY, 0, &startVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector for startVector
	IVector *startVector3D = NULL;
	status = activeWorkplane->Get3DVector(startVector2D, &startVector3D);
	CHECK_RETURN_STATUS(status)

	// Create the endVector
	IVector *endVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(endX, endY, 0, &endVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector for endVector
	IVector *endVector3D = NULL;
	status = activeWorkplane->Get3DVector(endVector2D, &endVector3D);
	CHECK_RETURN_STATUS(status)

	// Create basic straight line
	IBasicStraight *straight1 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(startVector3D, endVector3D, &straight1);
	CHECK_RETURN_STATUS(status)

	// Create aLine object
	ILine *line1 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, straight1), &line1);
	CHECK_RETURN_STATUS(status)
	*dLine1 = line1;

	// Apply AutoConstrain on the line created
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, line1));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the line created
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, line1));
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateLine")
}
